/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CombinationCraftingCategory
implements IRecipeCategory<ICombinationRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("extendedcrafting", "textures/gui/jei/combination_crafting.png");
    public static final ResourceLocation UID = new ResourceLocation("extendedcrafting", "combination");
    private final IDrawable background;
    private final IDrawable icon;

    public CombinationCraftingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 171);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.CRAFTING_CORE.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends ICombinationRecipe> getRecipeClass() {
        return ICombinationRecipe.class;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.combination").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public List<Component> getTooltipStrings(ICombinationRecipe recipe, double mouseX, double mouseY) {
        if (mouseX > 1.0 && mouseX < 14.0 && mouseY > 9.0 && mouseY < 86.0) {
            return Arrays.asList(new TextComponent(NumberFormat.getInstance().format(recipe.getPowerCost()) + " FE"), new TextComponent(NumberFormat.getInstance().format(recipe.getPowerRate()) + " FE/t"));
        }
        if (mouseX > 5.0 && mouseX < 23.0 && mouseY > 144.0 && mouseY < 165.0) {
            return recipe.getInputsList();
        }
        return Collections.emptyList();
    }

    public void setIngredients(ICombinationRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
        ingredients.setInputIngredients((List)recipe.m_7527_());
    }

    public void setRecipe(IRecipeLayout layout, ICombinationRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0);
        stacks.init(0, false, 76, 149);
        stacks.init(1, true, 76, 46);
        stacks.set(0, outputs);
        stacks.set(1, (List)inputs.get(0));
        double angleBetweenEach = 360.0 / (double)(inputs.size() - 1);
        Point point = new Point(53, 8);
        Point center = new Point(74, 47);
        for (int i = 2; i < inputs.size() + 1; ++i) {
            stacks.init(i, true, point.x, point.y);
            stacks.set(i, (List)inputs.get(i - 1));
            point = this.rotatePoint(point, center, angleBetweenEach);
        }
    }

    private Point rotatePoint(Point in, Point about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.x - about.x) - Math.sin(rad) * (double)(in.y - about.y) + (double)about.x;
        double newY = Math.sin(rad) * (double)(in.x - about.x) + Math.cos(rad) * (double)(in.y - about.y) + (double)about.y;
        return new Point((int)newX, (int)newY);
    }
}

